// File: /docs/03-contracts/generated/Contract—ui-button.md
# Contract Panel
## Header
Component ID: ui-button
Category (Prefix): ui
Variants: primary | secondary | destructive

## Intent
Primary action trigger in a SaaS interface

## Rules
Must
- Trigger a single, explicit user action
- Use semantic color tokens only
- Support disabled and loading states
- Have a minimum touch target (accessibility)
- Reflect intent through variant and context, not descriptive label text alone
- Be keyboard accessible

Must Not
- Perform navigation (use nav- components instead)
- Contain complex layouts or multiple actions
- Encode business logic
- Change intent via size or styling
- Be used as a container for other components

## Props / API
Props (Design)
- variant
- size
- icon (optional)
- fullWidth (boolean)
- disabled
- loading

Props (Code)
variant: "primary" | "secondary" | "destructive"
size: "sm" | "md" | "lg"
disabled?: boolean
loading?: boolean
fullWidth?: boolean
icon?: ReactNode | IconRef
onClick: () => void // no return value, no outcome assumption

## States
- default
- hover
- active
- disabled
- loading

## Slots
Slots (optional)

## Usage
Use When
- Triggering a primary or secondary user action
- Submitting forms
- Confirming decisions
- Performing a single, atomic action

Avoid When
- Navigating between pages (use nav components)
- Representing toggle or stateful controls
- Wrapping multiple actions
- Acting as a layout container

## Code Hint
Primary Code Hint: ui-button → Button

## Naming rules box
Format: [prefix]-[domain]-[role]--[variant]
ex: billing-plan-card--featured

# Component Preview Area

## Component Identity
Component ID: ui-button
Category (Prefix): ui
Component Type: Atomic

## Canonical Component Reference
Figma Component: UI / Actions / Button

Single Source of Truth
- This component definition is the canonical source
- Local copies or visual overrides are not permitted
- All variants and states must be implemented within this component

## Variant Matrix (As Implemented)
size: sm | md | lg

States
Primary States (Application-owned):
- default
- disabled
- loading

Interaction States (Visual-only):
- hover
- focus
- active

Rules
- No visual-only variants outside this list
- No variant nesting beyond these axes
- Variant combinations must be valid and intentional

## Token Dependency Contract
Consumes Tokens
- color.bg.primary
- color.text.on-primary
- color.border.primary
- space.*
- radius.*
- typography.*

Token Rules
- No raw values allowed
- No component-specific colours
- No local overrides

## Layout & Structure Rules
Layout Model
- Inline-flex button
- Optional leading and trailing icon
- Centered label

Spacing
- Padding and gap are token-driven
- Height is controlled by size variant only
- Width is container-controlled

## State → Visual Mapping
Default
- Primary background
- On-primary text colour

Hover
- Elevated or darkened primary background

Focus
- Visible focus ring
- Primary focus indicator

Active
- Pressed visual state

Disabled
- Reduced opacity
- No pointer or keyboard interaction

Loading
- Label hidden or muted
- Loading indicator visible
- Button width preserved
- Interaction disabled while loading

## Accessibility Guarantees
Accessibility
- Keyboard focusable
- Visible focus indicator
- Disabled state removed from tab order
- Loading state announced to assistive tech
- Meets WCAG AA contrast

## Structural Slots (If Applicable)
Slots
- leadingIcon (optional)
- trailingIcon (optional)
Slot Rules
- Icons inherit current text colour
- Slots must not affect button height
- Icons must not replace label text

## Naming Lock (Final)
Allowed Names: ui-button
Disallowed:
- ui-button-primary
- button-primary
- ui-primary-button

## Component Identity
Contract State: Locked

Behavioural Contract
- Inherits behaviour from ui-button

Changes Allowed
- Token updates (global only)
- Visual refinements without intent change

Changes Not Allowed
- New variants
- Behavioural changes
- Renaming
